package gov.va.vinci.dart.db;

import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.Person;

public interface PersonDAO  {

	Person findById(final int personId) throws ObjectNotFoundException;
	Person findByName(final String name) throws ObjectNotFoundException;
	Person findByNameCaseInsensitive(String name) throws ObjectNotFoundException;
	List<Person> listAll();
	List<Person> list(final String term);
	List<Person> listAllWithRole(final int roleId);
	List<Person> listByGroup(final int groupId);
	List<Person> listAllWithRoleAndGroup(final int roleId, final int groupId);
	List<Person> listAllWithRoleAndGroupAndNotifications(final int roleId, final int groupId);
	List<Person> listByGroupAndNotifications(final int groupId);
	void save(final Person person);
}
